<?php
/**
 * Create Contact Tag
 *
 * @package     AutomatorWP\Integrations\FluentCRM\Actions\Create_Contact_Tag
 * @author      AutomatorWP <contact@automatorwp.com>, Ruben Garcia <rubengcdev@gmail.com>
 * @since       1.0.4
 */
// Exit if accessed directly

if( !defined( 'ABSPATH' ) ) exit;

class AutomatorWP_FluentCRM_Create_Contact_Tag extends AutomatorWP_Integration_Action {

    public $integration = 'fluentcrm';
    public $action = 'fluentcrm_create_contact_tag';

    /**
     * Register the trigger
     *
     * @since 1.0.0
     */
    public function register() {

        automatorwp_register_action( $this->action, array(
            'integration'       => $this->integration,
            'label'             => __( 'Create tag and assign to contact', 'automatorwp-pro' ),
            'select_option'     => __( 'Create <strong>tag</strong> and assign to <strong>contact</strong>', 'automatorwp-pro' ),
            /* %1$s: Tag. %2$s: Contact. */
            'edit_label'        => sprintf( __( 'Create %1$s and assign to %2$s', 'automatorwp-pro' ), '{tag}', '{contact}' ),
            /* %1$s: Tag. %2$s: Contact. */
            'log_label'         => sprintf( __( 'Create %1$s and assign to %2$s', 'automatorwp-pro' ), '{tag}', '{contact}' ),
            'options'           => array(
                'tag' => array(
                    'from' => 'tag',
                    'default' => __( 'tag', 'automatorwp-pro' ),
                    'fields' => array(
                        'tag' => array(
                            'name' => __( 'Tag:', 'automatorwp-pro' ),
                            'desc' => __( 'The tag name', 'automatorwp-pro' ),
                            'type' => 'text',
                            'required'  => true,
                            'default' => ''
                        ),
                    )
                ),
                'contact' => array(
                    'from' => 'contact',
                    'default' => __( 'contact', 'automatorwp-pro' ),
                    'fields' => array(
                        'contact' => array(
                            'name' => __( 'Contact Email:', 'automatorwp-pro' ),
                            'type' => 'text',
                        ),
                    )
                ),
            ),
        ) );

    }

    /**
     * Action execution function
     *
     * @since 1.0.0
     *
     * @param stdClass  $action             The action object
     * @param int       $user_id            The user ID
     * @param array     $action_options     The action's stored options (with tags already passed)
     * @param stdClass  $automation         The action's automation object
     */
    public function execute( $action, $user_id, $action_options, $automation ) {

        global $wpdb;

        // Shorthand
        $tag_title = $action_options['tag'];
        $contact = $action_options['contact'];

        // Bail if empty tag to assign
        if( empty( $tag_title ) ) {
            return;
        }

        $tag_slug = sanitize_title( $tag_title, 'display' );

        $tag = $wpdb->get_row( $wpdb->prepare(
            "SELECT * FROM {$wpdb->prefix}fc_tags WHERE slug = %s",
            $tag_slug
        ) );

        // Create tag if not exists
        if( ! $tag ) {

            $tag_creation = FluentCrm\App\Models\Tag::updateOrCreate(
                array(
                    'slug' => $tag_slug,
                    'title' => $tag_title
                ),
                array( 'slug' => $tag_slug )
            );

            $tag_id = $wpdb->get_var( $wpdb->prepare(
                "SELECT id FROM {$wpdb->prefix}fc_tags WHERE slug = %s",
                $tag_slug
            ) );

        } else {
            $tag_id = $tag->id;
        }

        $subscriber = FluentCrm\App\Models\Subscriber::where( 'email', $contact )->first();

        // Bail if subscriber not exists
        if( ! $subscriber ) {
            return;
        }

        // Add tag to the user
        $subscriber->attachTags( array( $tag_id ) );

    }

}

new AutomatorWP_FluentCRM_Create_Contact_Tag();